/*:
 * @plugindesc This plugin lets you control the keys on the keyboard, and how they're mapped to the game.
 *
 * <pluginID ZE - Key Mapper>
 * @author Zalerinian
 *
 * @param Tab
 * @desc The mapping for the Tab key
 * @default tab
 *
 * @param Backspace
 * @desc The mapping for the backspace key
 * @default backspace
 *
 * @param Enter
 * @desc The mapping for the 'enter' or 'return' key
 * @default ok
 *
 * @param Shift
 * @desc The mapping for the 'shift' key
 * @default shift
 *
 * @param Control
 * @desc The mapping for the 'ctrl' or 'control' key
 * @default control
 *
 * @param Alt
 * @desc The mapping for the 'alt' key
 * @default control
 *
 * @param Pause
 * @desc The mapping for the 'pause' key
 * @default pause
 *
 * @param Capslock
 * @desc The mapping for the 'capslock' key
 * @default caps
 *
 * @param Escape
 * @desc The mapping for the 'escape' key
 * @default escape
 *
 * @param Space
 * @desc The mapping for the 'space' key
 * @default ok
 *
 * @param Pageup
 * @desc The mapping for the 'page up' key
 * @default pageup
 *
 * @param Pagedown
 * @desc The mapping for the 'page down' key
 * @default pagedown
 *
 * @param Home
 * @desc The mapping for the 'home' key
 * @default home
 *
 * @param End
 * @desc The mapping for the 'end' key
 * @default end
 *
 * @param Left
 * @desc The mapping for the left arrow
 * @default left
 *
 * @param Up
 * @desc The mapping for the 'up' arrow
 * @default up
 *
 * @param Right
 * @desc The mapping for the 'right' arrow
 * @default right
 *
 * @param Down
 * @desc The mapping for the 'down' arrow
 * @default down
 *
 * @param Print Screen
 * @desc The mapping for the 'Print Screen' key
 * @default prntscrn
 *
 * @param Insert
 * @desc The mapping for the 'insert' key
 * @default escape
 *
 * @param Delete
 * @desc The mapping for the 'delete' key
 * @default delete
 *
 * @param 0
 * @desc The mapping for the '0' key
 * @default 0
 *
 * @param 1
 * @desc The mapping for the '1' key
 * @default 1
 *
 * @param 2
 * @desc The mapping for the '2' key
 * @default 2
 *
 * @param 3
 * @desc The mapping for the '3' key
 * @default 3
 *
 * @param 4
 * @desc The mapping for the '4' key
 * @default 4
 *
 * @param 5
 * @desc The mapping for the '5' key
 * @default 5
 *
 * @param 6
 * @desc The mapping for the '6' key
 * @default 6
 *
 * @param 7
 * @desc The mapping for the '7' key
 * @default 7
 *
 * @param 8
 * @desc The mapping for the '8' key
 * @default 8
 *
 * @param 9
 * @desc The mapping for the '9' key
 * @default 9
 *
 * @param A
 * @desc The mapping for the 'a' key
 * @default a
 *
 * @param B
 * @desc The mapping for the 'b' key
 * @default b
 *
 * @param C
 * @desc The mapping for the 'c' key
 * @default c
 *
 * @param D
 * @desc The mapping for the 'd' key
 * @default d
 *
 * @param E
 * @desc The mapping for the 'e' key
 * @default e
 *
 * @param F
 * @desc The mapping for the 'f' key
 * @default f
 *
 * @param G
 * @desc The mapping for the 'g' key
 * @default g
 *
 * @param H
 * @desc The mapping for the 'h' key
 * @default h
 *
 * @param I
 * @desc The mapping for the 'i' key
 * @default i
 *
 * @param J
 * @desc The mapping for the 'j' key
 * @default j
 *
 * @param K
 * @desc The mapping for the 'k' key
 * @default k
 *
 * @param L
 * @desc The mapping for the 'l' key
 * @default l
 *
 * @param M
 * @desc The mapping for the 'm' key
 * @default m
 *
 * @param N
 * @desc The mapping for the 'n' key
 * @default n
 *
 * @param O
 * @desc The mapping for the 'o' key
 * @default o
 *
 * @param P
 * @desc The mapping for the 'p' key
 * @default p
 *
 * @param Q
 * @desc The mapping for the 'q' key
 * @default pageup
 *
 * @param R
 * @desc The mapping for the 'r' key
 * @default r
 *
 * @param S
 * @desc The mapping for the 's' key
 * @default s
 *
 * @param T
 * @desc The mapping for the 't' key
 * @default t
 *
 * @param U
 * @desc The mapping for the 'u' key
 * @default u
 *
 * @param V
 * @desc The mapping for the 'v' key
 * @default v
 *
 * @param W
 * @desc The mapping for the 'w' key
 * @default pagedown
 *
 * @param X
 * @desc The mapping for the 'x' key
 * @default escape
 *
 * @param Y
 * @desc The mapping for the 'y' key
 * @default y
 *
 * @param Z
 * @desc The mapping for the 'z' key
 * @default ok
 *
 * @param Semicolon
 * @desc The mapping for the ';' key
 * @default semicolon
 *
 * @param Equals
 * @desc The mapping for the '=' key
 * @default equals
 *
 * @param Minus
 * @desc The mapping for the '-' key
 * @default minus
 *
 * @param Super
 * @desc The mapping for the 'windows' or 'command' key
 * @default super
 *
 * @param Media
 * @desc The mapping for the 'media' key
 * @default media
 *
 * @param Num0
 * @desc The mapping for 0 with numlock on
 * @default num0
 *
 * @param Num1
 * @desc The mapping for 1 with numlock on
 * @default num1
 *
 * @param Num2
 * @desc The mapping for 2 with numlock is on.
 * @default down
 *
 * @param Num3
 * @desc The mapping for 3 with numlock on
 * @default num3
 *
 * @param Num4
 * @desc The mapping for 4 with numlock is on.
 * @default left
 *
 * @param Num5
 * @desc The mapping for 5 with numlock on
 * @default num5
 *
 * @param Num6
 * @desc The mapping for 6 with numlock is on.
 * @default right
 *
 * @param Num7
 * @desc The mapping for 7 with numlock on
 * @default num7
 *
 * @param Num8
 * @desc The mapping for 8 with numlock is on.
 * @default up
 *
 * @param Num9
 * @desc The mapping for 9 with numlock on.
 * @default num9
 *
 * @param Num*
 * @desc The mapping for * on the number pad.
 * @default multiply
 *
 * @param Num+
 * @desc The mapping for + on the number pad.
 * @default add
 *
 * @param Num-
 * @desc The mapping for - on the number pad.
 * @default subtract
 *
 * @param Num.
 * @desc The mapping for . on the number pad.
 * @default decimal
 *
 * @param Num/
 * @desc The mapping for / on the number pad.
 * @default divide
 *
 * @param F1
 * @desc The mapping for the 'F1' key
 * @default F1
 *
 * @param F2
 * @desc The mapping for the 'F2' key
 * @default F2
 *
 * @param F3
 * @desc The mapping for the 'F3' key
 * @default F3
 *
 * @param F4
 * @desc The mapping for the 'F4' key
 * @default F4
 *
 * @param F5
 * @desc The mapping for the 'F5' key
 * @default F5
 *
 * @param F6
 * @desc The mapping for the 'F6' key
 * @default F6
 *
 * @param F7
 * @desc The mapping for the 'F7' key
 * @default F7
 *
 * @param F8
 * @desc The mapping for the 'F8' key
 * @default F8
 *
 * @param F9
 * @desc The mapping for the 'F9' key
 * @default debug
 *
 * @param F10
 * @desc The mapping for the 'F10' key
 * @default F10
 *
 * @param F11
 * @desc The mapping for the 'F11' key
 * @default F11
 *
 * @param F12
 * @desc The mapping for the 'F12' key
 * @default F12
 *
 * @param Numlock
 * @desc The mapping for the 'numlock' key
 * @default numlock
 *
 * @param Scroll Lock
 * @desc The mapping for the 'scroll lock' key
 * @default scrollock
 *
 * @param Comma
 * @desc The mapping for the 'comma' key
 * @default comma
 *
 * @param Period
 * @desc The mapping for the 'period' key
 * @default period
 *
 * @param Slash
 * @desc The mapping for the 'slash' key
 * @default slash
 *
 * @param Backtick
 * @desc The mapping for the 'backtick' key
 * @default tilde
 *
 * @param Open Brace
 * @desc The mapping for the '[' key
 * @default [
 *
 * @param Backslash
 * @desc The mapping for the '\' key
 * @default \
 *
 * @param Closing Brace
 * @desc The mapping for the ']' key
 * @default ]
 *
 * @param Quote
 * @desc The mapping for the ' key
 * @default '
 *
 * @help
 * To remap a key, simply find it in the parameter list, and double click to
 * edit it. The values are the strings used in-game to check for input, and
 * that are case-sensitive, so it's recommended to use all lower-case for
 * the values.
 *
 * For movement, the values should be up, down, left, or right to move the
 * player in the respective directions.
 *
 * 'ok' is used as the action button
 *
 * 'escape' is used as the cancel button.
 *
 * 'shift' is used for dashing.
 *
 */

(function(){
  var params = PluginManager.parameters("ZE - Key Mapper");
  Input.keyMapper = {
    9:   params["Tab"          ],    // Tab
    8:   params["Backspace"    ],    // Backspace
    13:  params["Enter"        ],    // Enter
    16:  params["Shift"        ],    // Shift
    17:  params["Control"      ],    // Control
    18:  params["Alt"          ],    // Alt
    19:  params["Pause"        ],    // Media Pause
    20:  params["Capslock"     ],    // Caps lock
    27:  params["Escape"       ],    // Escape
    32:  params["Space"        ],    // Space
    33:  params["Pageup"       ],    // Page Up
    34:  params["Pagedown"     ],    // Page Down
    35:  params["Home"         ],    // Home
    36:  params["End"          ],    // End
    37:  params["Left"         ],    // Left Arrow
    38:  params["Up"           ],    // Up Arrow
    39:  params["Right"        ],    // Right Arrow
    40:  params["Down"         ],    // Down Arrow
    44:  params["Print"        ],    // Print Screen
    45:  params["Insert"       ],    // Insert (numlock off)
    46:  params["Delete"       ],    // Delete
    48:  params["0"            ],    // 0
    49:  params["1"            ],    // 1
    50:  params["2"            ],    // 2
    51:  params["3"            ],    // 3
    52:  params["4"            ],    // 4
    53:  params["5"            ],    // 5
    54:  params["6"            ],    // 6
    55:  params["7"            ],    // 7
    56:  params["8"            ],    // 8
    57:  params["9"            ],    // 9
    65:  params["A"            ],    // A
    66:  params["B"            ],    // B
    67:  params["C"            ],    // C
    68:  params["D"            ],    // D
    69:  params["E"            ],    // E
    70:  params["F"            ],    // F
    71:  params["G"            ],    // G
    72:  params["H"            ],    // H
    73:  params["I"            ],    // I
    74:  params["J"            ],    // J
    75:  params["K"            ],    // K
    76:  params["L"            ],    // L
    77:  params["M"            ],    // M
    78:  params["N"            ],    // N
    79:  params["O"            ],    // O
    80:  params["P"            ],    // P
    81:  params["Q"            ],    // Q
    82:  params["R"            ],    // R
    83:  params["S"            ],    // S
    84:  params["T"            ],    // T
    85:  params["U"            ],    // U
    86:  params["V"            ],    // V
    87:  params["W"            ],    // W
    88:  params["X"            ],    // X
    89:  params["Y"            ],    // Y
    90:  params["Z"            ],    // Z
    91:  params["Super"        ],    // Windows key
    93:  params["Media"        ],    // Windows Media key (?)
    96:  params["Num0"         ],    // Numpad 0
    97:  params["Num1"         ],    // Numpad 1
    98:  params["Num2"         ],    // Numpad 2
    99:  params["Num3"         ],    // Numpad 3
    100: params["Num4"         ],    // Numpad 4
    101: params["Num5"         ],    // Numpad 5
    102: params["Num6"         ],    // Numpad 6
    103: params["Num7"         ],    // Numpad 7
    104: params["Num8"         ],    // Numpad 8
    105: params["Num9"         ],    // Numpad 9
    106: params["Num*"         ],    // Numpad * (Multiply)
    107: params["Num+"         ],    // Numpad + (Add)
    109: params["Num-"         ],    // Numpad - (Subtract)
    110: params["Num."         ],    // Numpad . (Decimal)
    111: params["Num/"         ],    // Numpad / (Divide)
    112: params["F1"           ],    // F1
    113: params["F2"           ],    // F2
    114: params["F3"           ],    // F3
    115: params["F4"           ],    // F4
    116: params["F5"           ],    // F5
    117: params["F6"           ],    // F6
    118: params["F7"           ],    // F7
    119: params["F8"           ],    // F8
    120: params["F9"           ],    // F9
    121: params["F10"          ],    // F10
    122: params["F11"          ],    // F11
    123: params["F12"          ],    // F12
    144: params["Numlock"      ],    // Numlock
    145: params["Scroll Lock"  ],    // Scroll lock
    186: params["Semicolon"    ],    // Semicolon
     59: params["Semicolon"    ],    // Semicolon - Firefox is being stupid.
    187: params["Equals"       ],    // =
     61: params["Equals"       ],    // = - Firefox is being stupid
    188: params["Comma"        ],    // Comma
    173: params["Minus"        ],    // -
    189: params["Minus"        ],    // - Firefox is being stupid.
    190: params["Period"       ],    // Period
    191: params["Slash"        ],    // Slash
    192: params["Backtick"     ],    // Backtick (A.K.A Grave, also the same key as the tilde on US keyboards)
    219: params["Open Brace"   ],    // Open brace
    220: params["Backslash"    ],    // Backslash
    221: params["Closing Brace"],    // Closing brace
    222: params["Quote"        ]     // Quote
  };
})();